﻿using Performance.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;

namespace Performance.Repository
{
    public partial class PerforReportRepository : PerforRepository<PerReport>
    {
        public PerforReportRepository(PerformanceDbContext context) : base(context)
        {
        }

        /// <summary>
        /// 月群体人均绩效
        /// </summary>
        /// <returns></returns>
        public List<PerReport> GetAvgPerfor(int hospitalid)
        {
            string sql = @"SELECT
	                    t.date x,t.FitPeople y,ROUND(IFNULL(SUM(t.RealGiveFee),0)/count(1) ,2) value
                    FROM
	                    (
	                    SELECT	rc.ID,rc.AllotID,rc.AccountingUnit,
	                    CASE			
			                    WHEN rc.FitPeople = '临床科室主任人均绩效' THEN
			                    '院领导绩效' 
			                    WHEN rc.FitPeople = '临床科室中层人均绩效' THEN
			                    '行政职能中层绩效' 
			                    WHEN rc.FitPeople IN ( '临床科室护士人均绩效的95%', '临床科室护士长人均绩效', '' ) THEN
			                    '行政工勤绩效' 
			                    WHEN rc.FitPeople IN ( '科室主任人均绩效', '科室副主任人均绩效' ) THEN
			                    '临床主任绩效' 
			                    WHEN rc.FitPeople = '科室护士长人均绩效' THEN
			                    '临床护理绩效' 
		                    END FitPeople,
	                    rc.RealGiveFee,date_format( str_to_date( CONCAT( allot.`Month`, '/', allot.`Year` ), '%m/%Y' ), '%Y-%m' ) date 
                    FROM res_compute rc LEFT JOIN per_allot allot ON rc.AllotID = allot.ID 
                    WHERE allot.HospitalId=@hospitalid ) t 
                    GROUP BY t.date,t.FitPeople";
            return DapperQuery(sql, new { hospitalid }).ToList();
        }
    }
}
